The latest terms of use are available at https://developers.google.com/drive/api/v3/branding.

On the date 2020/08/17:

---

# Use the Google Drive brand
This page provides guidelines for use of [Google trademarks](http://www.google.com/permissions/guidelines.html). Consider these guidelines when naming, describing, and marketing your Google Drive app.

## Use Google Drive brand assets
You do not need pre-approval to use the Drive API or the Drive assets. However, your use of these assets is governed by the Drive API terms of service, and if that use violates branding requirements in the terms, Google may request that you modify or cease usage of the assets.

## Promote Google Drive on your website or marketing materials
Adhere to the following rules when promoting Google Drive on your website or within marketing materials:

 * The first reference to Google Drive should be "Google Drive™" with the trademark symbol. Additional references can be "Google Drive" or just "Drive."

 * You can use the provided assets to highlight your application's integration with Google Drive. If reference is made to Google Drive assets in connection with your logo, your logo must be larger than the Google trademark.

## Promote Google Drive on a blog or social media
When promoting Google Drive on a blog or social media, the first reference to Google Drive should be "Google Drive." Additional references can be "Google Drive" or just "Drive." The ™ symbol is not required.

## Promote Google Drive in an app store
When promoting Google Drive in an app store, such as the [G Suite Marketplace](https://gsuite.google.com/marketplace), the first reference to Google Drive should be "Google Drive™" with the trademark symbol. Additional references can be "Google Drive" or just "Drive."

You should also include the phrase "integrated with Google Drive" in your description.

In addition, when using the Google logo, you should adhere to the guidelines in the following documents :

* [Choosing an application or developer name](https://developer.chrome.com/webstore/branding#name)
* [Using Google logos](https://developer.chrome.com/webstore/branding#logos)
* [Describing your application](https://developer.chrome.com/webstore/branding#description)

The Google logo cannot be used as part of a sentence. The correct way to do this is to use text in the headline, and to place the Google logo elsewhere on the page.

## Promote Google Drive in your app
When promoting Google Drive in your app, you should follow these rules:

* Always refer to Google Drive in full name, for example, "Save to Google Drive."

* Use the Google Drive icon in your application in these ways:

* * As a button that initiates an action with Google Drive, such as saving to Google Drive.

* * To indicate that a file is stored in Google Drive.

* If available, use the colored version of the icon. You can also use a monochromatic version.

* Resist making alterations, other than changing the size, to the icons.

* Ensure any actions related to Google Drive are clear to the user by beginning actions with verb phrases, such as "Save to" or "Backup to."

* When using the Google Drive icon as a button, provide a tooltip indicating the action the button performs with Google Drive. For example, a button designed to save files to Google Drive should have the tooltip of "Save to Google Drive."

![Example button with tooltip](https://developers.google.com/drive/images/drive_tooltip.png)

* When a button contains the term "Google Drive," ensure the words "Google" and "Drive" are on the same line of button text.

* When a button contains text, don't combine that text with the Google or Google Drive logos.

* Don't abbreviate the term "Google Drive."

* When a button contains a reference to the term Google Drive, do not use the icon as a replacement for the term.

## Use the "Works with Google Drive" badge
To indicate that your app is integrated with Google Drive, use the "Works with Google Drive" badge. You do not need pre-approval to use this badge. However, ensure that your use of the badge is consistent with the terms of service and the branding guidelines on this page. Failure to follow the terms and guidelines can result in Google requiring you to modify the badge's use or even that you cease use of the badge. The badge should link to your app in the G Suite Marketplace.

![Drive app badge](https://developers.google.com/drive/images/drive_app_badge.png)

The badges are available with the other Google Drive assets.

When using the "Works with Google Drive" badge, follow these rules:

* Don’t modify the badge in any way, other than resizing.
* If you resize the badge, preserve the ratio of dimensions and ensure the badge is legible and fully visible.
* Don’t make the badge the primary element on your page.
* Keep some distance between the badge and other logos and icons on your page.
* Don’t use the badge on a page that contains or displays adult content, promotes gambling, promotes violence, contains hate speech, involves the sale of tobacco or alcohol to persons under twenty-one years of age, violates other applicable laws or regulations or is otherwise objectionable.
* Make sure that clicking the badge always links to your page in the G Suite Marketplace, and that your app, extension or theme is available in the store at all times that you use the badge.

## Use screenshots

For illustrative or informative purposes, you may use standard, unaltered screenshots of Google services. For further details, refer to [Google Permissions](http://www.google.com/permissions/index.html).

## Give proper attribution
Give proper attribution to Google for any use of their marks in your application title or in your description. Example:

Google Drive is a trademark of Google Inc. Use of this trademark is subject to Google Permissions.
